<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Files-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwadapter="urn:WebWorks-XSLT-Extension-Adapter"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwadapter wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterType" />


 <xsl:namespace-alias stylesheet-prefix="wwfiles" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwfiles-files-by-documentid" match="wwfiles:File" use="@documentID" />
 

 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Generate PDF files? -->
   <!--                     -->
   <xsl:if test="wwprojext:GetFormatSetting('pdf-per-group') = 'true'">
    <!-- Groups -->
    <!--        -->
    <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
    <xsl:variable name="VarProjectGroupsProgressStart" select="wwprogress:Start(count($VarProjectGroups))" />
    <xsl:for-each select="$VarProjectGroups">
     <xsl:variable name="VarProjectGroup" select="." />

     <xsl:variable name="VarProjectGroupProgressStart" select="wwprogress:Start(1)" />

     <!-- Group PDF PostScript -->
     <!--                      -->
     <xsl:for-each select="$GlobalFiles[1]">
      <xsl:variable name="VarPostScriptFilesCount" select="count(key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterDependsType)))" />
      <xsl:variable name="VarProjectChecksum" select="concat($VarProjectGroup/@GroupID, ':', $VarPostScriptFilesCount)" />

      <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwprojext:GetGroupDataDirectoryPath($VarProjectGroup/@GroupID), concat(translate($ParameterType, ':', '_'),'.ps'))" />
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, concat($VarProjectChecksum, ':', wwprojext:GetDocumentsToGenerateChecksum()), $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <!-- Delete previous PostScript file -->
       <!--                                 -->
       <xsl:if test="wwfilesystem:FileExists($VarPath)">
        <xsl:variable name="VarDeleteFile" select="wwfilesystem:DeleteFile($VarPath)" />
       </xsl:if>

       <!-- Combine documents -->
       <!--                   -->
       <xsl:for-each select="$VarProjectGroup//wwproject:Document">
        <xsl:variable name="VarProjectDocument" select="." />

        <xsl:for-each select="$GlobalFiles[1]">
         <xsl:variable name="VarPostScriptFile" select="key('wwfiles-files-by-documentid', $VarProjectDocument/@DocumentID)[@type = $ParameterDependsType][1]" />
         <xsl:for-each select="$VarPostScriptFile">
          <!-- Append files -->
          <!--              -->
          <xsl:variable name="VarAppendFile" select="wwfilesystem:AppendFileWithFile($VarPath, $VarPostScriptFile/@path)" />
         </xsl:for-each>
        </xsl:for-each>
       </xsl:for-each>
      </xsl:if>

      <!-- Track files -->
      <!--             -->
      <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{concat($VarProjectChecksum, ':', wwprojext:GetDocumentsToGenerateChecksum())}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}">
       <xsl:for-each select="$VarProjectGroup//wwproject:Document">
        <xsl:variable name="VarProjectDocument" select="." />

        <xsl:for-each select="$GlobalFiles[1]">
         <xsl:variable name="VarPostScriptFile" select="key('wwfiles-files-by-documentid', $VarProjectDocument/@DocumentID)[@type = $ParameterDependsType][1]" />
         <xsl:for-each select="$VarPostScriptFile">
          <wwfiles:Depends path="{$VarPostScriptFile/@path}" checksum="{$VarPostScriptFile/@checksum}" groupID="{$VarPostScriptFile/@groupID}" documentID="{$VarPostScriptFile/@documentID}" />
         </xsl:for-each>
        </xsl:for-each>
       </xsl:for-each>
      </wwfiles:File>
     </xsl:for-each>
 
     <xsl:variable name="VarProjectGroupProgressEnd" select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:variable name="VarProjectGroupsProgressEnd" select="wwprogress:End()" />
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>
</xsl:stylesheet>
